/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Test;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.L_Ender.cataclysm.message.MessageMusic;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class ComplexEntity
extends PathfinderMob {
    private int reducedDamageTicks;
    private int homeTicks;
    protected final int HOME_COOLDOWN = CMConfig.Return_Home * 20;
    protected final int NATURE_HEAL_COOLDOWN = 200;
    private int self_regen;
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.defineId(ComplexEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final EntityDataAccessor<String> DIMENSION_TYPE = SynchedEntityData.defineId(ComplexEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.defineId(ComplexEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ResourceLocation MOB_HEALTH_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"animation_health");
    private static final ResourceLocation MOB_DAMAGE_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"animation_damage");
    public int attackTicks;

    public ComplexEntity(EntityType<? extends ComplexEntity> type, Level world) {
        super(type, world);
    }

    public void setHomePos(BlockPos homePos) {
        this.entityData.set(HOME_POS, (Object)homePos);
    }

    public BlockPos getHomePos() {
        return (BlockPos)this.entityData.get(HOME_POS);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME_POS, (Object)BlockPos.ZERO);
        builder.define(DIMENSION_TYPE, (Object)"minecraft:overworld");
        builder.define(ATTACK_STATE, (Object)0);
    }

    public int getAttackState() {
        return (Integer)this.entityData.get(ATTACK_STATE);
    }

    public void setAttackState(int input) {
        this.attackTicks = 0;
        this.entityData.set(ATTACK_STATE, (Object)input);
        this.level().broadcastEntityEvent((Entity)this, (byte)(-input));
    }

    public String getDimensionType() {
        return (String)this.entityData.get(DIMENSION_TYPE);
    }

    public void setDimensionType(String dimenType) {
        this.entityData.set(DIMENSION_TYPE, (Object)dimenType);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("HomePosX", this.getHomePos().getX());
        compound.putInt("HomePosY", this.getHomePos().getY());
        compound.putInt("HomePosZ", this.getHomePos().getZ());
        compound.putString("DimensionType", this.getDimensionType());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        int i = compound.getInt("HomePosX");
        int j = compound.getInt("HomePosY");
        int k = compound.getInt("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
        this.setDimensionType(compound.getString("DimensionType"));
        super.readAdditionalSaveData(compound);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.homeTicks = this.HOME_COOLDOWN;
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean hurt(DamageSource source, float damage) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, damage);
        }
        damage = Math.min(this.DamageCap(), damage);
        if (this.ReducedDamage(source) && this.reducedDamageTicks > 0) {
            float reductionFactor = 1.0f - (float)this.reducedDamageTicks / (float)this.DamageTime();
            damage *= reductionFactor;
        }
        if (source.is(ModTag.BLOCK_SELF_REGEN)) {
            this.self_regen = 200;
        }
        boolean flag = super.hurt(source, damage);
        if (this.ReducedDamage(source) && flag) {
            this.reducedDamageTicks = this.DamageTime();
        }
        return flag;
    }

    public boolean ReducedDamage(DamageSource damageSource) {
        return !damageSource.is(ModTag.BYPASSES_HURT_TIME) && this.DamageTime() > 0;
    }

    public void handleEntityEvent(byte id) {
        if (id <= 0) {
            this.attackTicks = 0;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.canAttack((LivingEntity)player) && this.distanceTo((Entity)player) < 2500.0f;
    }

    public static void setConfigattribute(LivingEntity entity, double hpconfig, double dmgconfig) {
        AttributeInstance attackDamageAttr;
        AttributeInstance maxHealthAttr = entity.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealthAttr != null) {
            double difference = maxHealthAttr.getBaseValue() * hpconfig - maxHealthAttr.getBaseValue();
            maxHealthAttr.addTransientModifier(new AttributeModifier(MOB_HEALTH_MODIFIER_ID, difference, AttributeModifier.Operation.ADD_VALUE));
            entity.setHealth(entity.getMaxHealth());
        }
        if ((attackDamageAttr = entity.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
            double difference = attackDamageAttr.getBaseValue() * dmgconfig - attackDamageAttr.getBaseValue();
            attackDamageAttr.addTransientModifier(new AttributeModifier(MOB_DAMAGE_MODIFIER_ID, difference, AttributeModifier.Operation.ADD_VALUE));
        }
    }

    public double calculateRange(DamageSource damagesource) {
        return damagesource.getEntity() != null ? this.distanceToSqr(damagesource.getEntity()) : -1.0;
    }

    public double getAngleBetweenEntities(Entity first, Entity second) {
        return Math.atan2(second.getZ() - first.getZ(), second.getX() - first.getX()) * 57.29577951308232 + 90.0;
    }

    public void disableShield(Player player, int ticks) {
        if (player.isBlocking() && !player.level().isClientSide) {
            player.disableShield();
            player.getCooldowns().addCooldown(player.getUseItem().getItem(), ticks);
            player.stopUsingItem();
        }
    }

    protected boolean canPlayMusic() {
        return !this.isSilent() && this.getTarget() instanceof Player && this.getTarget() != null && this.getTarget().isAlive();
    }

    protected void tickDeath() {
        this.onDeathUpdate(this.deathtimer());
    }

    public SoundEvent getBossMusic() {
        return null;
    }

    public int deathtimer() {
        return 20;
    }

    protected void onDeathAIUpdate() {
    }

    public void onDeathUpdate(int deathDuration) {
        this.onDeathAIUpdate();
        ++this.deathTime;
        if (this.deathTime >= deathDuration && !this.level().isClientSide() && !this.isRemoved()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public void die(DamageSource cause) {
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.isRemoved() && !this.dead) {
            Entity entity = cause.getEntity();
            LivingEntity livingentity = this.getKillCredit();
            if (this.deathScore >= 0 && livingentity != null) {
                livingentity.awardKillScore((Entity)this, this.deathScore, cause);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                if (entity == null || entity.killedEntity(serverlevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverlevel, cause);
                    this.createWitherRose(livingentity);
                    this.AfterDefeatBoss(livingentity);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.setPose(Pose.DYING);
        }
    }

    protected void AfterDefeatBoss(@Nullable LivingEntity p_21269_) {
    }

    public void circleEntity(Entity target, float radius, float speed, boolean direction, int circleFrame, float offset, float moveSpeedMultiplier) {
        int directionInt = direction ? 1 : -1;
        double t = (double)(directionInt * circleFrame) * 0.5 * (double)speed / (double)radius + (double)offset;
        Vec3 movePos = target.position().add((double)radius * Math.cos(t), 0.0, (double)radius * Math.sin(t));
        this.getNavigation().moveTo(movePos.x, movePos.y, movePos.z, (double)(speed * moveSpeedMultiplier));
    }

    protected void repelEntities(float x, float y, float z, float radius) {
        List<LivingEntity> nearbyEntities = this.getEntityLivingBaseNearby(x, y, z, radius);
        for (Entity entity : nearbyEntities) {
            if (!entity.isPickable() || entity.noPhysics) continue;
            double angle = (this.getAngleBetweenEntities((Entity)this, entity) + 90.0) * Math.PI / 180.0;
            entity.setDeltaMovement(-0.1 * Math.cos(angle), entity.getDeltaMovement().y, -0.1 * Math.sin(angle));
        }
    }

    public void tick() {
        super.tick();
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (!this.level().isClientSide && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this, (CustomPacketPayload)new MessageMusic(this.getId(), true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)this, (CustomPacketPayload)new MessageMusic(this.getId(), false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (this.reducedDamageTicks > 0) {
            --this.reducedDamageTicks;
        }
        if (this.self_regen > 0) {
            --this.self_regen;
        }
        if (!this.level().isClientSide()) {
            LivingEntity target = this.getTarget();
            if (!this.isNoAi()) {
                if (this.self_regen <= 0 && !this.isNoAi() && this.NatureRegen() > 0.0f && target == null && this.tickCount % 20 == 0) {
                    this.heal(this.NatureRegen());
                }
                if (CMConfig.Return_Home > 0) {
                    if (this.homeTicks > 0) {
                        --this.homeTicks;
                    }
                    if (target != null) {
                        this.homeTicks = this.HOME_COOLDOWN;
                    }
                    if (this.homeTicks <= 0) {
                        this.ReturnToHome();
                    }
                }
            }
        }
    }

    protected void ReturnToHome() {
        Level level;
        if (this.getHomePos() != null && this.getHomePos() != BlockPos.ZERO && (level = this.level()) instanceof ServerLevel) {
            ServerLevel targetLevel;
            boolean isInvalidDim;
            ServerLevel serverLevel = (ServerLevel)level;
            String dimStr = this.getDimensionType();
            ResourceLocation parsed = ResourceLocation.tryParse((String)dimStr);
            boolean bl = isInvalidDim = dimStr == null || dimStr.contains("ResourceKey") || parsed == null;
            if (isInvalidDim) {
                System.err.println("[DIM] Malformed dimension string detected: " + dimStr + " \u2192 Replacing with current dimension.");
                parsed = serverLevel.dimension().location();
                this.setDimensionType(parsed.toString());
            }
            ResourceKey targetDim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)parsed);
            if (!serverLevel.dimension().location().equals((Object)parsed) && (targetLevel = serverLevel.getServer().getLevel(targetDim)) != null) {
                this.changeDimension(new DimensionTransition(targetLevel, this.position(), this.getDeltaMovement(), this.getYRot(), this.getXRot(), DimensionTransition.DO_NOTHING));
                this.moveTo((double)this.getHomePos().getX() + 0.5, this.getHomePos().getY(), (double)this.getHomePos().getZ() + 0.5, this.getYRot(), this.getXRot());
                this.homeTicks = this.HOME_COOLDOWN;
                return;
            }
            if (!this.getHomePos().closerToCenterThan((Position)this.position(), 16.0)) {
                this.moveTo((double)this.getHomePos().getX() + 0.5, this.getHomePos().getY(), (double)this.getHomePos().getZ() + 0.5, this.getYRot(), this.getXRot());
                this.homeTicks = this.HOME_COOLDOWN;
            }
        }
    }

    public void push(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!(this.isSleeping() || this.isPassengerOfSameVehicle(entityIn) || entityIn.noPhysics || this.noPhysics || !((d2 = Mth.absMax((double)(d0 = entityIn.getX() - this.getX()), (double)(d1 = entityIn.getZ() - this.getZ()))) >= (double)0.01f))) {
            d2 = Mth.sqrt((float)((float)d2));
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.isVehicle() && this.canBePushedByEntity(entityIn)) {
                this.push(-d0, 0.0, -d1);
            }
            if (!entityIn.isVehicle()) {
                entityIn.push(d0, 0.0, d1);
            }
        }
    }

    public float DamageCap() {
        return Float.MAX_VALUE;
    }

    public float NatureRegen() {
        return 0.0f;
    }

    public int DamageTime() {
        return 40;
    }

    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public boolean canUsePortal(boolean allowPassengers) {
        return false;
    }

    public boolean canBeAffected(MobEffectInstance p_34192_) {
        return p_34192_.getEffect().getDelegate().is(ModTag.EFFECTIVE_FOR_BOSSES) && super.canBeAffected(p_34192_);
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected boolean canRide(Entity p_31508_) {
        return false;
    }

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.level().getEntitiesOfClass(entityClass, this.getBoundingBox().inflate(dX, dY, dZ), e -> e != this && (double)this.distanceTo((Entity)e) <= r + (double)(e.getBbWidth() / 2.0f) && e.getY() <= this.getY() + dY);
    }
}

